' Filter and window shapes for the multi-tone modem by SP9VRC

WindowLen = 64
AliasFilterLen = 64
DecimateRatio = 3

PI = 3.141592653589793#

OPEN "newqpsk.dat" FOR OUTPUT AS #1

' Anti-alias input and output filters (at 8000 Hz sampling)
' Objectives: DO pass 1625+/-1050 Hz
'             do NOT pass bandwidth wider than 8000/3 Hz

Bins = AliasFilterLen / 2

DIM K(0 TO Bins - 1) AS DOUBLE
FOR i = 0 TO Bins - 1: K(i) = 0: NEXT i
FOR i = 13 - 7 TO 13 + 7: K(i) = 1!: NEXT i
K(13 - 8) = .75: K(13 + 8) = .75
K(13 - 9) = .2825: K(13 + 9) = .2825
K(13 - 10) = .0326: K(13 + 10) = .0326

' PRINT #1, "AliasFilterLen equ ", AliasFilterLen
' PRINT #1, ""
PRINT #1, "     org Y:AliasFilterInpI"
FOR t = -Bins + .5 TO Bins - .5
 sum = 0:
 FOR i = 0 TO Bins - 1: sum = sum + K(i) * COS(PI * i * t / Bins): NEXT i
 sum = sum / Bins
 PRINT #1, "        dc", USING "#.########"; sum
NEXT t
PRINT #1, ""

PRINT #1, "     org Y:AliasFilterInpQ"
FOR t = -Bins + .5 TO Bins - .5
 sum = 0:
 FOR i = 0 TO Bins - 1: sum = sum + K(i) * SIN(PI * i * t / Bins): NEXT i
 sum = sum / Bins
 PRINT #1, "        dc", USING "#.########"; sum
NEXT t
PRINT #1, ""

PRINT #1, "     org X:AliasFilterOutI"
FOR t = -Bins + .5 TO Bins - .5
 sum = 0:
 FOR i = 0 TO Bins - 1: sum = sum + K(i) * COS(PI * i * t / Bins): NEXT i
 sum = sum / Bins
 PRINT #1, "        dc", USING "#.########"; sum
NEXT t
PRINT #1, ""

PRINT #1, "     org X:AliasFilterOutQ"
FOR t = -Bins + .5 TO Bins - .5
 sum = 0:
 FOR i = 0 TO Bins - 1: sum = sum + K(i) * SIN(PI * i * t / Bins): NEXT i
 sum = sum / Bins
 PRINT #1, "        dc", USING "#.########"; sum
NEXT t
PRINT #1, ""

' FFT window shapes
' Input windows are scaled down by WindowLen/2 to prevent FFT overflows

Bins = WindowLen / 2

' For receiving tuning tones: a bit wider to accept +/- 75 Hz mis-tune
PRINT #1, "     org Y:ToneWindowInp"
FOR t = -Bins + .5 TO Bins - .5
 win = .5 + COS(PI * t / Bins) + .589 * COS(PI * 2 * t / Bins) + .1 * COS(PI * 3 * t / Bins)
 PRINT #1, "        dc", USING "#.########"; win / 2.189 / (WindowLen / 2)
NEXT t
PRINT #1, ""

' For transmiting tuning tones: classic raised cosine to get pure tones
' we attenuate this one a bit so the receiver's signal stay unchanged
' when the transmitter switches from pure tone to alternating phase
PRINT #1, "     org Y:ToneWindowOut"
FOR t = -Bins + .5 TO Bins - .5
 win = COS(PI / 2 * t / Bins)
 PRINT #1, "        dc", USING "#.########"; win * win / 1.2
NEXT t
PRINT #1, ""

' For data receiving/transmiting: optimized for minimal crosstalks

' K(0) = .39031899#
' K(1) = .5680425099999999#
' K(2) = .15850893#
' K(3) = -.07645668#
' K(4) = -.05377841#
' K(5) = .00346368#
' K(6) = 0.0
' K(7) = 0.0
' K(8) = 0.0

' an alternative set with very low crosstalk but wide freq. spectrum
K(0) = .37353458#
K(1) = .56663815#
K(2) = .19436159#
K(3) = -6.777465000000001D-02
K(4) = -9.404609999999999D-02
K(5) = -.01705343#
K(6) = .02536151#
K(7) = .01323943#
K(8) = -.00416208#

' this one is a comprimise of low crosstalk and narrow freq. spectrum
'K(0) = 0.38421841
'K(1) = 0.56599719
'K(2) = 0.16818387
'K(3) = -0.06956221
'K(4) = -0.07097936
'K(5) = -0.00187879
'K(6) = 0.01344377
'K(7) = 0.00049331
'K(8) = 0.00018282

PRINT #1, "     org Y:DataWindowOut"
FOR t = -Bins + .5 TO Bins - .5
 sum = K(0):
 FOR i = 1 TO 8: sum = sum + K(i) * COS(PI * i * t / Bins): NEXT i
 PRINT #1, "        dc", USING "#.########"; sum
NEXT t
PRINT #1, ""

' we scale down the input window by more, as it has more overall power
' so the receiver's signal stays unchaged when it switches from
' tone to data window
PRINT #1, "     org Y:DataWindowInp"
FOR t = -Bins + .5 TO Bins - .5
 sum = K(0):
 FOR i = 1 TO 8: sum = sum + K(i) * COS(PI * i * t / Bins): NEXT i
 PRINT #1, "        dc", USING "#.########"; sum / (WindowLen / 2) / 1.7
NEXT t
PRINT #1, ""

' Now a very non-trivial issue: the initial phases...

DataCarriers = 15
TuneCarriers = 4
CarrierAmpl = 1! / 16
K = PI
'K = 3.3 / (DataCarriers / 2) ^ 2
'K = (PI / 4) / (DataCarriers - 1)
DIM PhaseI(16)
DIM PhaseQ(16)

PRINT #1, "     org X:TxDataIniVect"
FOR i = 1 TO DataCarriers
phi = 8! * PI * i * i / DataCarriers
'! phi = 8 * PI * i * i / DataCarriers
' phi = 12! * i * i / DataCarriers
' phi = DataCarriers * PI * SQR((i - 1) / DataCarriers)
' phi = 4 * PI * (i + 3) * (i + 3) / (DataCarriers + 3)
' phi = K * i * i / DataCarriers
' phi = K * (i - 1) * (DataCarriers - i)
' phi = K * (i - 1)
 PRINT #1, "        dc", USING "#.########"; CarrierAmpl * COS(phi)
 PhaseI(i) = CarrierAmpl * COS(phi)
NEXT i
PRINT #1, ""
PRINT #1, "     org Y:TxDataIniVect"
FOR i = 1 TO DataCarriers
phi = 8! * PI * i * i / DataCarriers
'! phi = 8 * PI * i * i / DataCarriers
' phi = 12! * i * i / DataCarriers
' phi = DataCarriers * PI * SQR((i - 1) / DataCarriers)
' phi = 4 * PI * (i + 3) * (i + 3) / (DataCarriers + 3)
' phi = K * i * i / DataCarriers
' phi = K * (i - 1) * (DataCarriers - i)
' phi = K * (i - 1)
 PRINT #1, "        dc", USING "#.########"; CarrierAmpl * SIN(phi)
 PhaseQ(i) = CarrierAmpl * SIN(phi)
NEXT i
PRINT #1, ""

PRINT #1, "     org X:TxTuneIniVect"
FOR i = 2 TO DataCarriers STEP 4
 PRINT #1, "        dc", USING "#.########"; 2 * PhaseI(i)
NEXT i
PRINT #1, ""
PRINT #1, "     org Y:TxTuneIniVect"
FOR i = 2 TO DataCarriers STEP 4
 PRINT #1, "        dc", USING "#.########"; 2 * PhaseQ(i)
NEXT i
PRINT #1, ""

CLOSE #1


